<header class="header" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light">
            <a class="navbar-brand logo d-lg-none d-block" href="<?php echo e(route('home')); ?>">
                <img src="<?php echo e(siteLogo()); ?>" alt="<?php echo app('translator')->get('image'); ?>">
            </a>

            <div class="search-box style-two w-100 d-lg-none d-block">
                <form class="search-form">
                    <input type="text" class="form--control pill exclude" name="search" placeholder="Search..."
                        id="mobile-search" <?php if(request()->routeIs('products') || request()->routeIs('category.products')): ?> value="<?php echo e(request()->search); ?>" <?php endif; ?>>
                    <button type="submit" class="search-box__button">
                        <span class="icon"><i class="las la-search"></i></span>
                    </button>
                </form>
            </div>

            <?php if($categories->count()): ?>
                <div class="category-nav">
                    <button class="category-nav__button">
                        <span class="icon me-1"><img src="<?php echo e(asset($activeTemplateTrue . 'images/icons/grid.png')); ?>"
                                alt="<?php echo app('translator')->get('image'); ?>"></span><span class="search-text"><?php echo app('translator')->get(' Category'); ?></span>
                        <span class="arrow"><i class="las la-angle-down"></i></span>
                    </button>
                    <ul class="dropdown--menu">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="dropdown--menu__item">
                                <a href="<?php echo e(route('category.products', ['slug' => slug($category->name), 'id' => $category->id])); ?>"
                                    class="dropdown--menu__link">
                                    <?php echo e(strLimit($category->name, 18)); ?>

                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            <button class="navbar-toggler header-button" type="button" data-bs-toggle="collapse"
                data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false"
                aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav nav-menu ms-auto align-items-lg-center">
                    <li class="nav-item <?php echo e(menuActive('home')); ?>">
                        <a class="nav-link" aria-current="page" href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                    </li>

                    <?php
                        $pages = App\Models\Page::where('tempname', $activeTemplate)
                            ->where('is_default', Status::NO)
                            ->get();
                    ?>

                    <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $isActive = route('pages', [$data->slug]) == request()->url(); ?>
                        <li class="nav-item <?php if($isActive): ?> active <?php endif; ?>">
                            <a class="nav-link" aria-current="page"
                                href="<?php echo e(route('pages', [$data->slug])); ?>"><?php echo e(__($data->name)); ?></a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <li class="nav-item <?php echo e(menuActive(['products', 'category.products'])); ?>">
                        <a class="nav-link" href="<?php echo e(route('products')); ?>"><?php echo app('translator')->get('Product'); ?></a>
                    </li>
                    <li class="nav-item <?php echo e(menuActive('blog*')); ?>">
                        <a class="nav-link" href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->get('Blog'); ?></a>
                    </li>
                    <li class="nav-item <?php echo e(menuActive('contact')); ?>">
                        <a class="nav-link" href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                    </li>
                    <li class="nav-item d-lg-none d-flex justify-content-between align-items-end">
                        <div class="accounts-buttons d-flex align-items-center">
                            <?php if(auth()->guard()->check()): ?>
                                <a href="<?php echo e(route('user.logout')); ?>" class="accounts-buttons__link">
                                    <span class="icon fs-14 me-1"><i
                                            class="fas fa-sign-out-alt"></i></span><?php echo app('translator')->get('Logout'); ?>
                                </a>
                            <?php else: ?>
                                <a href="<?php echo e(route('user.login')); ?>" class="accounts-buttons__link">
                                    <span class="icon fs-14 me-1"><i class="fas fa-sign-in-alt"></i></span>
                                    <?php echo app('translator')->get('Login'); ?>
                                </a>
                            <?php endif; ?>

                            <?php if(auth()->guard()->check()): ?>
                                <a href="<?php echo e(route('user.home')); ?>" class="btn btn--base btn--sm">
                                    <span class="icon fs-14 me-1"><i class="fas fa-home"></i></span> <?php echo app('translator')->get('Dashboard'); ?>
                                </a>
                            <?php else: ?>
                                <a href="<?php echo e(route('user.register')); ?>" class="btn btn--base btn--sm">
                                    <span class="icon fs-14 me-1"><i class="fas fa-user-plus"></i></span> <?php echo app('translator')->get('Register'); ?>
                                </a>
                            <?php endif; ?>
                        </div>
                        <?php if(gs('multi_language')): ?>
                            <?php
                                $language = App\Models\Language::all();
                            ?>
                            <div class="custom--dropdown">
                                <?php if(session('lang')): ?>
                                    <div class="custom--dropdown__selected dropdown-list__item">
                                        <div class="thumb">
                                            <img class="flag" alt="image"
                                                src="<?php echo e(getImage(getFilePath('language') . '/' . @$language->where('code', session('lang'))->first()->image, getFileSize('language'))); ?>">
                                        </div>
                                        <span class="text"><?php echo e(strtoupper(session('lang'))); ?></span>
                                    </div>
                                <?php else: ?>
                                    <?php $default = $language->where('is_default',Status::YES)->first() ?>
                                    <div class="custom--dropdown__selected dropdown-list__item">
                                        <div class="thumb">
                                            <img class="flag" alt="image"
                                                src="<?php echo e(getImage(getFilePath('language') . '/' . @$default->image, getFileSize('language'))); ?>">
                                        </div>
                                        <span class="text"><?php echo e(strtoupper(@$default->code)); ?></span>
                                    </div>
                                <?php endif; ?>
                                <ul class="dropdown-list">
                                    <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="dropdown-list__item langSel"
                                            data-url="<?php echo e(route('home')); ?>/change/<?php echo e($item->code); ?>">
                                            <div class="thumb">
                                                <img class="flag" alt="image"
                                                    src="<?php echo e(getImage(getFilePath('language') . '/' . $item->image, getFileSize('language'))); ?>"
                                                    loading="lazy">
                                            </div>
                                            <span class="text"><?php echo e(strtoupper($item->code)); ?></span>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </li>
                </ul>
            </div>
        </nav>
    </div>
</header>

<?php $__env->startPush('style'); ?>
    <style>
        @media screen and (max-width:992px) {
            .navbar {
                gap: 20px;
            }

            .navbar-brand {
                flex: 1 1 calc(77% - 40px);
            }

            .search-box {
                order: 4;
                width: auto !important;
                max-width: unset !important;
                flex: 1 1 50%;
            }

            .category-nav {
                width: 26%;
                order: 3;
                min-width: max-content;
                text-align: left;
            }
        }

        .navbar .search-box {
            max-width: 100%;
            position: relative;
            top: 100%;
            visibility: visible;
            opacity: 1;
            transition: all ease 250ms;
            z-index: 9;
            margin-top: 0;
        }

        @media screen and (max-width: 470px) {
            .navbar {
                gap: 15px;
                column-gap: 10px;
            }
        }

        @media screen and (max-width: 424px) {
            .dropdown--menu {
                width: 180px;
                left: 0;
                right: 0;
            }
        }

        @media screen and (max-width: 374px) {
            .navbar-brand {
                flex: 1 1 calc(77% - 0px);
            }

            .search-text {
                display: none;
            }

            .category-nav {
                width: 10%;
            }

            .category-nav__button .icon {
                margin-right: 0 !important;
            }

            .category-nav .arrow {
                display: none;
            }
        }
    </style>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/gpboost/accts.gpboost.com/core/resources/views/templates/basic/partials/header_bottom.blade.php ENDPATH**/ ?>